------------------------------------------------------------------------------------------------------------------------------------
function createDefendArmies()
	LeftDef = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 3500,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},
		2,NumberOfUAs)
		LeftDef.DefPos = GetPosition("defendArea1")
		LeftDef.CommandDelayer = 5
	LeftDefSpawner = UnlimitedArmySpawnGenerator:New(LeftDef,{
	Position = GetPosition("defleftspawn"),
	ArmySize = 7,
	SpawnCounter = 180,
	SpawnLeaders = 7,
	LeaderDesc= {
		{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
		{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
		{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 2, Looped = true, Experience = 3},
		{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 1, Looped = true, Experience = 3},
	},
	Generator = "TofDeffLinksSpawner",
	})
	RightDef = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 3500,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},
		3,NumberOfUAs)
		RightDef.DefPos = GetPosition("defendArea2")
		RightDef.CommandDelayer = 5
	RightDefSpawner = UnlimitedArmySpawnGenerator:New(RightDef,{
	Position = GetPosition("assaultTwoPrepare"),
	ArmySize = 7,
	SpawnCounter = 180,
	SpawnLeaders = 7,
	LeaderDesc= {
		{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
		{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 4, SpawnNum = 4, Looped = true, Experience = 3},
		{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 2, Looped = true, Experience = 3},
		{LeaderType = Entities.PV_Cannon4, SoldierNum = 0, SpawnNum = 1, Looped = true, Experience = 3},
	},
	Generator = "TofDeffRechtsSpawner",
	})
	RightDef:AddCommandLuaFunc(DefendBase,true)
	LeftDef:AddCommandLuaFunc(DefendBase,true)
	
	BackDef = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 3500,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},4,NumberOfUAs)
	BackDefSpawner = UnlimitedArmySpawnGenerator:New(BackDef,{
	Position = GetPosition("BackDefSpawn"),
	ArmySize = 15,
	SpawnCounter = 180,
	SpawnLeaders = 15,
	LeaderDesc = {
		{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8 , SpawnNum = 3, Looped = true, Experience = 3},
		{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8 , SpawnNum = 3, Looped = true, Experience = 3},
		{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8 , SpawnNum = 5, Looped = true, Experience = 3},
		{LeaderType = Entities.PV_Cannon3, SoldierNum = 0 , SpawnNum = 4, Looped = true, Experience = 3},
	},
	Generator = "BackDef"
	})
	--BackDef:AddCommandLuaFunc(MoveToPoint,true)
	BackDef:AddCommandMove(GetPosition("BackDefPoint1"),true)
	BackDef:AddCommandWaitForIdle(true)
	BackDef:AddCommandMove(GetPosition("BackDefPoint2"),true)
	BackDef:AddCommandWaitForIdle(true)
	BackDef:AddCommandMove(GetPosition("BackDefPoint3"),true)
	BackDef:AddCommandWaitForIdle(true)
	
	LkavBaseDef = LazyUnlimitedArmy:New({
		Player = 7,
		Area = 3500,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},5,NumberOfUAs)
		LkavBaseDef.Points = {GetPosition("LkavPoint1"),GetPosition("LkavPoint2"),GetPosition("LkavPoint3"),GetPosition("LkavPoint4"),GetPosition("LkavPoint5")}
		LkavBaseDef.LastPoint = nil
		LkavBaseDef.CurrentPoint = math.random(1,5)
	LkavDefSpawner = UnlimitedArmySpawnGenerator:New(LkavBaseDef,{
		Position = GetPosition("lkavsoeldner"),
		ArmySize = 20,
		SpawnCounter = 300,
		SpawnLeaders = 20,
		LeaderDesc = {
			{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 3, SpawnNum = 20, Looped = true, Experience = 3}
		},
		Generator = "LkavDef"
	})
	LkavBaseDef:AddCommandMove(GetPosition("LkavPoint"..LkavBaseDef.CurrentPoint),false)
	LkavBaseDef:AddCommandWaitForIdle(false)
	local numbertable = {1,2,3,4,5}
	LkavBaseDef.LastPoint = table.remove(numbertable,LkavBaseDef.CurrentPoint)
	local nextpoint = numbertable[math.random(1,4)]
	LkavBaseDef:AddCommandMove(GetPosition("LkavPoint"..nextpoint),false)
	LkavBaseDef.CurrentPoint = nextpoint
	LkavBaseDef:AddCommandLuaFunc(SoeldnerMove,true)
end
function SoeldnerMove(self)
	local thiefcounter = {Logic.GetPlayerEntitiesInArea(1, Entities.PU_Thief, 43552.98, 54944.44, 20000, 16)}
	if thiefcounter[1] > 0 then
		if self:IsIdle() then
			return false,UnlimitedArmy.CreateCommandMove(GetPosition(thiefcounter[2]),false)
		end
		return false 
	end
	if not self:IsIdle() then
		return false
	end
	local numbertable = {1,2,3,4,5}
	table.remove(numbertable,self.LastPoint)
	for k,v in pairs(numbertable) do
		if v == self.CurrentPoint then
			self.LastPoint = table.remove(numbertable,k)
			break;
		end
	end
	self.CurrentPoint = numbertable[math.random(1,3)]
	return false,UnlimitedArmy.CreateCommandMove(self.Points[self.CurrentPoint],false)
end
--TODO: brauchen?
function MoveToPoint(self)
	if not self:IsIdle() then
		return false
	end
	
end

function DefendBase(self)
		if self.CommandDelayer >= 0 then
			self.CommandDelayer = self.CommandDelayer -1
			return false
		else
			self.CommandDelayer = 5
		end
		if GetDistance(self:GetPosition(),self.DefPos) > 8000 then
			return false, UnlimitedArmy.CreateCommandFlee(self.DefPos)
		else
			return false, UnlimitedArmy.CreateCommandDefend(self.DefPos,8000)
		end
		return false
end